//
//  CustomMoviePlayerViewController.m
//
//  Copyright iOSDeveloperTips.com All rights reserved.
//

#import "CustomMoviePlayerViewController.h"

#pragma mark -
#pragma mark Compiler Directives & Static Variables

@implementation CustomMoviePlayerViewController

@synthesize sd; //standar duration or DU (initially)
@synthesize timer;

// Nielsen/Client Variables
NSString *clientID=@"us-502202";
NSString *vcid=@"c06";
NSString *sfcode=@"us";
NSString *prod=@"vc";
NSString *cg=@"test movie";
NSString *title=@"this is the dog, cat & monkey video";
NSString *ou=@"ou-value";
float pingTime = 10;

//Nielsen - Other Video Variables
float timeSec = 0;
float dav1Duration = 0;



#pragma mark -
#pragma CustomMoviePlayerViewController lifecycle

/*---------------------------------------------------------------------------
 * 
 *--------------------------------------------------------------------------*/
- (void) loadView
{
    [self setView:[[[UIView alloc] initWithFrame:[[UIScreen mainScreen] applicationFrame]] autorelease]];
	[[self view] setBackgroundColor:[UIColor blackColor]];
}

/*---------------------------------------------------------------------------
 *  
 *--------------------------------------------------------------------------*/
- (void)dealloc 
{
    [sd release];
	[mp release];
    [movieURL release];
	[super dealloc];
}


/*---------------------------------------------------------------------------
 * 
 *--------------------------------------------------------------------------*/
- (id)initWithPath:(NSString *)moviePath
{
	// Initialize and create movie URL
    if (self = [super init])
    {
        movieURL = [NSURL fileURLWithPath:moviePath];    
        [movieURL retain];
        
    }
	return self;
}




/*---------------------------------------------------------------------------
 * For 3.2 and 4.x devices
 * For 3.1.x devices see moviePreloadDidFinish:
 *--------------------------------------------------------------------------*/
- (void) moviePlayerLoadStateChanged:(NSNotification*)notification 
{
	// Unless state is unknown, start playback
	if ([mp loadState] != MPMovieLoadStateUnknown)
    {
        // Remove observer
        [[NSNotificationCenter 	defaultCenter] 
         removeObserver:self
         name:MPMoviePlayerLoadStateDidChangeNotification 
         object:nil];
        
        // When tapping movie, status bar will appear, it shows up
        // in portrait mode by default. Set orientation to landscape
        [[UIApplication sharedApplication] setStatusBarOrientation:UIInterfaceOrientationLandscapeRight animated:NO];
        
		// Rotate the view for landscape playback
        [[self view] setBounds:CGRectMake(0, 0, 480, 320)];
		[[self view] setCenter:CGPointMake(160, 240)];
		[[self view] setTransform:CGAffineTransformMakeRotation(M_PI / 2)]; 
        
		// Set frame of movieplayer
		[[mp view] setFrame:CGRectMake(0, 0, 480, 320)];
        
        // Add movie player as subview
        [[self view] addSubview:[mp view]];   
        
        
        //Gets Movie Duration, converts to string for input into Nielsen TAGs
        double myfx=mp.duration;
        NSNumber *sdfl=[NSNumber numberWithDouble:myfx];
        NSNumberFormatter *sdf=[[[NSNumberFormatter alloc] init] autorelease];
        [sdf setGeneratesDecimalNumbers:NO];
        ;
        
     
        sd =[[NSString stringWithString:[sdf stringFromNumber:sdfl]] retain];

        [self fireDav:0];  //Kicks off all Nielsen Video CODE
        [self davPing];  //Call DAV Ping Method
		[mp play];// Play the movie


        
        
	}
}

#pragma mark -
#pragma Nielsen Events Creation

-(void) fireDav:(int) davType{
    
    //Creates RND number and encodes title of video
    double myf=((double)rand()/RAND_MAX)*1000000000;
    NSNumber *fl=[NSNumber numberWithDouble:myf];
    NSNumberFormatter *f=[[[NSNumberFormatter alloc] init] autorelease];
    [f setGeneratesDecimalNumbers:NO];
    NSString *stRandom = [f stringFromNumber:fl];
    
    NSMutableString *stURL =[NSMutableString stringWithFormat:
                             @"http://secure-%@.imrworldwide.com/cgi-bin/m?",
                             sfcode];
    
    NSString *escapedTitle = (NSString *)CFURLCreateStringByAddingPercentEscapes(NULL,
                                                                                   (CFStringRef)title,
                                                                                   NULL,
                                                                                   (CFStringRef)@"!*'();:@&=+$,/?%#[]",
                                                                                   kCFStringEncodingUTF8 );
    
    
    NSMutableString *stURLParams =[NSMutableString stringWithFormat:
                               @"ci=%@&cg=%@&tl=dav%d-%@&c6=%@,%@&cc=1&rnd=%@&ou=%@",
                               clientID,cg,davType,escapedTitle,prod,vcid,stRandom,ou];
                               
    
     
    
    float Dav1PingConversion = dav1Duration;
    NSString *duConversion = [NSString stringWithFormat:@"%.0f",Dav1PingConversion];
    
    switch (davType) {
        case 0:
            [stURLParams appendFormat:@"&sd=%@",[self sd]];
            break;
        case 1:
            [stURLParams appendFormat:@"&du=%@",duConversion];
            break;
        case 2:
            [stURLParams appendFormat:@"&du=%@",[self sd]];
            break;
        default:
            break;
    }

    
    
    [stURL appendString:stURLParams];
    [escapedTitle release];
    NSLog(@"*** Generated URL: %@",stURL);
    
    NSString* escapedUrl = [stURL stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]; 
    NSURL *url = [NSURL URLWithString:escapedUrl]; 
  
    NSURLRequest * urlRequest = [NSURLRequest requestWithURL:url];
    NSURLResponse * response = nil;
    NSError * error = nil;
    NSData * data = [NSURLConnection sendSynchronousRequest:urlRequest returningResponse:&response error:&error];
    


    
    
    if( response )
    {
        NSLog(@"*** Response Expected Content Length: %qiB", [response expectedContentLength]);
        NSLog(@"*** Response Content FileName: %@", [response suggestedFilename]);
        NSLog(@"*** Response MIME-Type: %@", [response MIMEType ]);
        
        //If pixel data is necessary:
        UIImage *image=[UIImage imageWithData:data];
        NSLog(@"*** Response Pixel Image: height:%f - width:%f.", image.size.height, image.size.width);
     
    }
    else 
    {
        NSLog(@"*** Response Error: %@", error);
    }

}



#pragma -
#pragma Timer handling
-(void) davPing  //Calls Timer
{
	timer = [NSTimer scheduledTimerWithTimeInterval:1.0 target:self selector:@selector(timerTick:) userInfo:nil repeats:YES];
	[[NSRunLoop currentRunLoop] addTimer:timer forMode:NSDefaultRunLoopMode];
}


- (void)timerTick:(NSTimer *)timer  //Timer fires DAV1 under condition Duration is less than SD
{
	timeSec++;
	
	
	if (timeSec == pingTime)
	{
        NSLog(@"*** Elapsed Time: %f",timeSec);
		dav1Duration = dav1Duration + pingTime;
        NSLog(@"*** Duration: %f",dav1Duration);
		timeSec = 0;
		
		if (dav1Duration < mp.duration)
		{
			[self fireDav:1];
		}
		
	}
}


#pragma -mark
#pragma MPMoviePlayer Lifecycle
/*---------------------------------------------------------------------------
 *
 *--------------------------------------------------------------------------*/
- (void) readyPlayer
{
 	mp =  [[MPMoviePlayerController alloc] initWithContentURL:movieURL];
    
    if ([mp respondsToSelector:@selector(loadState)]) 
    {
        // Set movie player layout
        [mp setControlStyle:MPMovieControlStyleFullscreen];
        [mp setFullscreen:YES];
        
		// May help to reduce latency
		[mp prepareToPlay];
        
		// Register that the load state changed (movie is ready)
		[[NSNotificationCenter defaultCenter] addObserver:self 
                                                 selector:@selector(moviePlayerLoadStateChanged:) 
                                                     name:MPMoviePlayerLoadStateDidChangeNotification 
                                                   object: nil];
	}  
    else
    {
        // Register to receive a notification when the movie is in memory and ready to play.
        [[NSNotificationCenter defaultCenter] addObserver:self 
                                                 selector:@selector(moviePreloadDidFinish:) 
                                                     name:MPMoviePlayerContentPreloadDidFinishNotification 
                                                   object:nil];
    }
    
    // Register to receive a notification when the movie has finished playing. 
    [[NSNotificationCenter defaultCenter] addObserver:self 
                                             selector:@selector(moviePlayBackDidFinish:) 
                                                 name:MPMoviePlayerPlaybackDidFinishNotification 
                                               object:nil];
    
    
}

/*---------------------------------------------------------------------------
 * For 3.1.x devices
 * For 3.2 and 4.x see moviePlayerLoadStateChanged: 
 *--------------------------------------------------------------------------*/
- (void) moviePreloadDidFinish:(NSNotification*)notification 
{
	// Remove observer
	[[NSNotificationCenter 	defaultCenter] 
     removeObserver:self
     name:MPMoviePlayerContentPreloadDidFinishNotification
     object:nil];
    
	// Play the movie
	[mp play];
}


/*---------------------------------------------------------------------------
 * 
 *--------------------------------------------------------------------------*/
- (void) moviePlayBackDidFinish:(NSNotification*)notification 
{    
    NSLog(@"Movie playback did finish...");
     
    [[UIApplication sharedApplication] setStatusBarHidden:YES];
    
 	// Remove observer
    [[NSNotificationCenter 	defaultCenter] 
     removeObserver:self
     name:MPMoviePlayerPlaybackDidFinishNotification 
     object:nil];
    
    dav1Duration=0;
    [timer invalidate];
    NSLog(@"Reseting fav1 to: %f",dav1Duration);
	[self dismissModalViewControllerAnimated:YES];	
	[self fireDav:2];  //FIRE DAV2 when Playback finished 
    
    
}

@end
