package org.apache.android.media;
import android.content.Context;
import android.util.AttributeSet;
import android.widget.VideoView;

public class CustomVideoView extends VideoView{
 
	private VideoViewListener mListener;

	public CustomVideoView(Context context) {
        super(context);
    }

    public CustomVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CustomVideoView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setVideoViewListener(VideoViewListener listener) {
        mListener = listener;
    }

    @Override
    public void pause() {
        super.pause();
        if (mListener != null) {
            mListener.onPause();
        }
    }

    @Override
    public void start() {
        super.start();
        if (mListener != null) {
            mListener.onPlay();
        }
    }
    
    @Override
    public void seekTo(int msec){
    	super.seekTo(msec);
    	if(mListener != null)
    		mListener.onSeekTo(msec);
    }
    
    public int getCurrentPositionSec() {
    	return Math.round(super.getCurrentPosition()/1000);
    }

    interface VideoViewListener {
        void onPlay();
        void onPause();
        void onSeekTo(int msec);
    }

}