/*
 * Decompiled with CFR 0.152.
 */
package com.nielsen.vcbeacon.events;

import android.util.Log;
import com.nielsen.vcbeacon.events.IDispatcher;
import com.nielsen.vcbeacon.events.IEvent;
import com.nielsen.vcbeacon.events.IEventListener;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventDispatcher
implements IDispatcher {
    private static final String TAG = EventDispatcher.class.getSimpleName();
    private HashMap<String, CopyOnWriteArrayList<IEventListener>> listeners = new HashMap();
    private IDispatcher destination;

    public EventDispatcher() {
        this(null);
    }

    public EventDispatcher(IDispatcher destination) {
        this.destination = destination != null ? destination : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventListener(String type, IEventListener listener) {
        try {
            HashMap<String, CopyOnWriteArrayList<IEventListener>> hashMap = this.listeners;
            synchronized (hashMap) {
                CopyOnWriteArrayList<IEventListener> list = this.listeners.get(type);
                if (list == null) {
                    list = new CopyOnWriteArrayList();
                    this.listeners.put(type, list);
                }
                list.add(listener);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error adding listener: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEventListener(String type, IEventListener listener) {
        try {
            HashMap<String, CopyOnWriteArrayList<IEventListener>> hashMap = this.listeners;
            synchronized (hashMap) {
                CopyOnWriteArrayList<IEventListener> list = this.listeners.get(type);
                if (list == null) {
                    return;
                }
                list.remove(listener);
                if (list.size() == 0) {
                    this.listeners.remove(type);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error adding listener: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasListener(String type, IEventListener listener) {
        HashMap<String, CopyOnWriteArrayList<IEventListener>> hashMap = this.listeners;
        synchronized (hashMap) {
            CopyOnWriteArrayList<IEventListener> list;
            block4: {
                list = this.listeners.get(type);
                if (list != null) break block4;
                return false;
            }
            return list.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(IEvent event) {
        CopyOnWriteArrayList<IEventListener> list;
        if (event == null) {
            Log.e((String)TAG, (String)"event is null");
            return;
        }
        String type = event.getEventType();
        event.setEventSource(this.destination);
        HashMap<String, CopyOnWriteArrayList<IEventListener>> hashMap = this.listeners;
        synchronized (hashMap) {
            list = this.listeners.get(type);
        }
        if (list == null) {
            return;
        }
        for (IEventListener l : list) {
            l.onEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        HashMap<String, CopyOnWriteArrayList<IEventListener>> hashMap = this.listeners;
        synchronized (hashMap) {
            this.listeners.clear();
        }
        this.destination = null;
    }
}

