/*
 * Decompiled with CFR 0.152.
 */
package com.nielsen.vcbeacon;

import android.app.Activity;
import android.os.Bundle;
import android.widget.TextView;
import com.nielsen.vcbeacon.LPSender;
import com.nielsen.vcbeacon.events.IEvent;
import com.nielsen.vcbeacon.events.IEventListener;
import com.nielsen.vcbeacon.models.BeaconMsgModel;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class VCBeaconActivity
extends Activity {
    private Map<String, String> config = new HashMap<String, String>();
    private String baseURl = ".imrworldwide.com/cgi-bin/m?";
    private String startURL = "http://secure-";
    private String sendURL = null;
    private Integer maxPos = 0;
    private BeaconMsgModel beaconMsg = new BeaconMsgModel();
    private IEventListener requestBeaconMsg = new IEventListener(){

        @Override
        public void onEvent(IEvent passedEvent) {
            TextView myTextOutputObj = VCBeaconActivity.this.beaconMsg.getTextOutputObj();
            if (myTextOutputObj != null) {
                myTextOutputObj.append((CharSequence)("\n\n" + VCBeaconActivity.this.beaconMsg.getMyMessage()));
            }
        }
    };

    public VCBeaconActivity() {
    }

    public VCBeaconActivity(TextView textObj) {
        this.registerForReturnBeaconUrl(textObj);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.config.put("clientid", "us-502202");
        this.config.put("vcid", "c06");
        this.config.put("sfcode", "us");
        this.config.put("prod", "vc");
        this.config.put("cg", "test movie");
        this.config.put("title", "this is the dog, cat & monkey video");
        this.config.put("ou", "ou-value");
        this.config.put("cliptype", "content");
        this.config.put("duration", "0");
    }

    public void initalize(Map<String, String> o) {
        this.config.put("clientid", "us-502202");
        this.config.put("vcid", "c06");
        this.config.put("sfcode", "us");
        this.config.put("prod", "vc");
        this.config.put("cg", "test movie");
        this.config.put("title", "this is the dog, cat & monkey video");
        this.config.put("ou", "ou-value");
        this.config.put("cliptype", "content");
        this.config.put("duration", "0");
        this.config.put("pingduration", "10");
        for (Map.Entry<String, String> entry : o.entrySet()) {
            if (!this.config.containsKey(entry.getKey())) continue;
            this.config.put(entry.getKey(), entry.getValue());
        }
    }

    private void registerForReturnBeaconUrl(TextView textOutputObj) {
        if (this.beaconMsg == null) {
            return;
        }
        this.beaconMsg.addEventListener("beaconMessageRequested", this.requestBeaconMsg);
        this.beaconMsg.setTextOutputObj(textOutputObj);
    }

    public void play(Map<String, String> clipData) {
        for (Map.Entry<String, String> entry : clipData.entrySet()) {
            if (!this.config.containsKey(entry.getKey())) continue;
            this.config.put(entry.getKey(), entry.getValue());
        }
        try {
            this.sendDav(0);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.maxPos = 0;
    }

    public void stop(Integer num) {
        if (num > this.maxPos) {
            this.maxPos = num;
        }
        if (num > Integer.parseInt(this.config.get("duration"))) {
            this.maxPos = Integer.parseInt(this.config.get("duration"));
        }
        try {
            this.sendDav(2);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void ping(Integer num) {
        if (num <= this.maxPos || num > Integer.parseInt(this.config.get("duration"))) {
            return;
        }
        this.maxPos = num;
        try {
            this.sendDav(1);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void sendDav(Integer num) throws UnsupportedEncodingException {
        this.sendURL = String.valueOf(this.startURL) + this.config.get("sfcode") + this.baseURl;
        this.sendURL = String.valueOf(this.sendURL) + "cc=1";
        this.sendURL = String.valueOf(this.sendURL) + "&ci=" + this.config.get("clientid");
        this.sendURL = String.valueOf(this.sendURL) + "&cg=" + URLEncoder.encode(this.config.get("cg"), "UTF-8");
        this.sendURL = String.valueOf(this.sendURL) + "&c6=" + this.config.get("prod") + "," + this.config.get("vcid");
        this.sendURL = String.valueOf(this.sendURL) + "&rnd=" + Math.round(Math.random() * 1000000.0);
        this.sendURL = String.valueOf(this.sendURL) + "&ou=" + URLEncoder.encode(this.config.get("ou"), "UTF-8");
        String queryString = "";
        switch (num) {
            case 0: {
                queryString = "&tl=dav0-" + URLEncoder.encode(this.config.get("title"), "UTF-8");
                queryString = String.valueOf(queryString) + "&sd=" + this.config.get("duration");
                break;
            }
            default: {
                queryString = "&tl=dav" + num + "-" + URLEncoder.encode(this.config.get("title"), "UTF-8");
                queryString = String.valueOf(queryString) + "&du=" + this.maxPos;
            }
        }
        if (this.config.get("cliptype") == "ad") {
            queryString = String.valueOf(queryString) + "&c3=st,a";
        }
        String senderURL = String.valueOf(this.sendURL) + queryString;
        senderURL = senderURL.replaceAll("\\+", "%20");
        System.out.println("senderURL == " + senderURL);
        LPSender sender = new LPSender();
        sender.execute(new String[]{senderURL});
        if (this.beaconMsg != null && this.beaconMsg.hasListener("beaconMessageRequested", this.requestBeaconMsg)) {
            this.beaconMsg.setMyMessage(senderURL);
        }
    }
}

